<?php

$botToken = "7467589620:AAH_ViMxz2QMqXkdecyPiOD3Wx7mFH-9lFc";
$adminId = "7568537739";
$channelUsername = "@Hyper_Backup";
$channelLink = "https://t.me/Hyper_Backup";

$update = json_decode(file_get_contents("php://input"), true);

$chat_id = $update["message"]["chat"]["id"] ?? $update["callback_query"]["message"]["chat"]["id"] ?? null;
$user_id = $update["message"]["from"]["id"] ?? $update["callback_query"]["from"]["id"] ?? null;
$username = $update["message"]["from"]["username"] ?? "";
$first_name = $update["message"]["from"]["first_name"] ?? "";
$last_name = $update["message"]["from"]["last_name"] ?? "";
$text = $update["message"]["text"] ?? "";
$callback_data = $update["callback_query"]["data"] ?? "";
$callback_id = $update["callback_query"]["id"] ?? null;
$message_id = $update["callback_query"]["message"]["message_id"] ?? null;

$dataPath = __DIR__ . "/data";
if (!is_dir($dataPath)) mkdir($dataPath);
$orderFile = "$dataPath/order.json";
$userFile = "$dataPath/new_users.json";

if (!file_exists($orderFile)) file_put_contents($orderFile, json_encode([], JSON_PRETTY_PRINT));
if (!file_exists($userFile)) file_put_contents($userFile, json_encode([], JSON_PRETTY_PRINT));

$orders = json_decode(file_get_contents($orderFile), true);
$users = json_decode(file_get_contents($userFile), true);

$bannedPath = "$dataPath/banned_$user_id.json";
if (file_exists($bannedPath)) {
    sendMessage($chat_id, "🚫 আপনি এই বট থেকে ব্যান হয়েছেন। দয়া করে অ্যাডমিনের সাথে যোগাযোগ করুন।");
    exit;
}

if ($text == "/start") {
    if (!isUserExist($user_id, $users)) {
        $userData = [
            "user_id" => $user_id,
            "username" => $username,
            "first_name" => $first_name,
            "last_name" => $last_name,
            "time" => date("Y-m-d H:i:s")
        ];
        $users[] = $userData;
        file_put_contents($userFile, json_encode($users, JSON_PRETTY_PRINT));

        $totalUsers = count($users);
        $text = "🆕 নতুন একজন ইউজার বটে যুক্ত হয়েছে।\n\n👤 নাম: $first_name $last_name\n📛 ইউজারনেম: @$username\n🆔 ইউজার আইডি: $user_id\n🔗 <a href='tg://user?id=$user_id'>প্রোফাইল দেখুন</a>\n\n👥 মোট ইউজার: $totalUsers";

        sendMessage($adminId, $text, [
            "inline_keyboard" => [
                [
                    ["text" => "🚫 ব্যান করুন", "callback_data" => "ban_$user_id"]
                ]
            ]
        ]);
    }

    if (!checkChannelJoin($user_id, $channelUsername, $botToken)) {
        sendMessage($chat_id, "❗️ আপনাকে আমাদের চ্যানেলে যুক্ত হতে হবে। নিচের বাটন থেকে চ্যানেলে যান এবং তারপর 'আমি জয়েন করেছি' বাটনে ক্লিক করুন।", [
            "inline_keyboard" => [
                [
                    ["text" => "🔗 চ্যানেল জয়েন করুন", "url" => "$channelLink"]
                ],
                [
                    ["text" => "✅ আমি জয়েন করেছি", "callback_data" => "check_join"]
                ]
            ]
        ]);
        exit;
    }

    sendMessage($chat_id, "🎉 আপনি সফলভাবে চ্যানেলে যুক্ত হয়েছেন! নিচের বাটনে ক্লিক করে ওয়েব অ্যাপ খুলুন:", [
        "inline_keyboard" => [
            [["text" => "🌐 ওয়েব অ্যাপ খুলুন", "web_app" => ["url" => "https://bughuntpro.online/Pro"]]]
        ]
    ]);
}

if ($callback_data == "check_join") {
    if (!checkChannelJoin($user_id, $channelUsername, $botToken)) {
        answerCallback($callback_id, "❌ আপনি এখনো চ্যানেলে যুক্ত হননি!", true);
    } else {
        editMessage($chat_id, $message_id, "🎉 আপনি এখন চ্যানেলে যুক্ত হয়েছেন! নিচের বাটনে ক্লিক করে ওয়েব অ্যাপ খুলুন:", [
            "inline_keyboard" => [
                [["text" => "🌐 ওয়েব অ্যাপ খুলুন", "web_app" => ["url" => "https://hyper.battlecore.xyz"]]]
            ]
        ]);
    }
}

if (strpos($callback_data, "ban_") === 0 && $user_id == $adminId) {
    $target_id = str_replace("ban_", "", $callback_data);
    file_put_contents("$dataPath/banned_$target_id.json", json_encode(["banned" => true], JSON_PRETTY_PRINT));
    editMessage($chat_id, $message_id, "🚫 ইউজারটি ব্যান করা হয়েছে।");
}

if (strpos($callback_data, "unban_") === 0 && $user_id == $adminId) {
    $target_id = str_replace("unban_", "", $callback_data);
    $banFile = "$dataPath/banned_$target_id.json";
    if (file_exists($banFile)) unlink($banFile);
    editMessage($chat_id, $message_id, "✅ ইউজারটি আনব্যান করা হয়েছে।");
}

if ($text == "/broadcast" && $user_id == $adminId) {
    sendMessage($chat_id, "📢 দয়া করে আপনার ব্রডকাস্ট মেসেজ পাঠান:");
    file_put_contents("$dataPath/broadcast_mode.json", json_encode(["status" => true]));
    exit;
}

if (file_exists("$dataPath/broadcast_mode.json")) {
    $bcast = json_decode(file_get_contents("$dataPath/broadcast_mode.json"), true);
    if ($bcast['status'] && $user_id == $adminId && $text != "/broadcast") {
        foreach ($users as $u) {
            $uid = $u['user_id'];
            if (!file_exists("$dataPath/banned_$uid.json")) {
                sendMessage($uid, "📢 ব্রডকাস্ট:\n\n" . $text);
            }
        }
        unlink("$dataPath/broadcast_mode.json");
        sendMessage($chat_id, "✅ ব্রডকাস্ট সম্পন্ন হয়েছে");
    }
}

function isUserExist($user_id, $users) {
    foreach ($users as $u) {
        if ($u["user_id"] == $user_id) return true;
    }
    return false;
}

function checkChannelJoin($user_id, $channel, $token) {
    $url = "https://api.telegram.org/bot$token/getChatMember?chat_id=$channel&user_id=$user_id";
    $res = json_decode(file_get_contents($url), true);
    if (isset($res["result"]["status"])) {
        $status = $res["result"]["status"];
        return in_array($status, ["member", "administrator", "creator"]);
    }
    return false;
}

function sendMessage($chat_id, $text, $keyboard = null) {
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $post = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($keyboard) {
        $post['reply_markup'] = json_encode(["inline_keyboard" => $keyboard["inline_keyboard"]]);
    }
    file_get_contents($url . "?" . http_build_query($post));
}

function editMessage($chat_id, $message_id, $text, $keyboard = null) {
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/editMessageText";
    $post = [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($keyboard) {
        $post['reply_markup'] = json_encode(["inline_keyboard" => $keyboard["inline_keyboard"]]);
    }
    file_get_contents($url . "?" . http_build_query($post));
}

function answerCallback($callback_id, $text, $alert = false) {
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/answerCallbackQuery";
    $post = [
        'callback_query_id' => $callback_id,
        'text' => $text,
        'show_alert' => $alert
    ];
    file_get_contents($url . "?" . http_build_query($post));
}

?>
