<?php

// Bot credentials
$botToken = "7467589620:AAH_ViMxz2QMqXkdecyPiOD3Wx7mFH-9lFc";
$adminId = "7568537739";

// File paths
$dataDir = __DIR__ . '/data';
$orderFile = $dataDir . '/order.json';
$sentFile = $dataDir . '/send.json';

// Ensure data folder and files exist
if (!file_exists($orderFile)) exit("No order file found.");
if (!file_exists($sentFile)) file_put_contents($sentFile, json_encode([]));

// Load data
$orders = json_decode(file_get_contents($orderFile), true);
$sent = json_decode(file_get_contents($sentFile), true);

if (!is_array($orders)) $orders = [];
if (!is_array($sent)) $sent = [];

// Loop through orders to find first unsent
foreach ($orders as $order) {
    $txId = $order['transaction_id'] ?? null;
    if (!$txId || in_array($txId, $sent)) continue;

    // Format message
    $msg = "🛒 <b>New Order Received</b>\n";
    $msg .= "━━━━━━━━━━━━━━━\n";
    $msg .= "🔹 Service: <b>{$order['service_name']}</b>\n";
    $msg .= "🔹 Transaction ID: <code>{$order['transaction_id']}</code>\n";
    $msg .= "🔹 Amount: <b>{$order['amount']}৳</b>\n";
    $msg .= "🔹 Last 4 Digits: <b>{$order['last_payment_number']}</b>\n";
    $msg .= "🔹 Email: <code>{$order['email']}</code>\n";
    $msg .= "⏰ Submitted: {$order['submission_time']}";

    // Send to admin
    sendMessage($adminId, $msg);

    // Save transaction ID to send.json
    $sent[] = $txId;
    file_put_contents($sentFile, json_encode($sent, JSON_PRETTY_PRINT));
    
    // Stop after sending one
    break;
}

function sendMessage($chat_id, $text) {
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $post = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

?>